<?php

class Jingshi {

    public $settings;
    private  $jingshi_username = '';
    private  $jingshi_key = '';
    private  $jingshi_url = 'http://cz.ecadmin.cn/api/user/';

    function __construct() {
    }

    public function externalduanxin($code,$mobile,$tpl_id = 51880,$tpl_value = null) {
        $username = $this->jingshi_username;
        $key = $this->jingshi_key;
        $url = $this->jingshi_url.'externalduanxin';

        if(!$tpl_value){
            $tpl_value = urlencode("#code#=".$code);
        }
        $data = [
            'username'=>$username,
            'key'=>$key,
            'mobile'=>$mobile,
            'tpl_value'=>$tpl_value,
            'tpl_id'=>$tpl_id,
        ];

        try {
            $content = $this->fetchContent($url, 'POST', $data);
            return json_decode($content,true);
        } catch (\Exception $e) {
            return false;
        }
    }

    public function externalhuafei($mobile,$pervalue) {
        $username = $this->jingshi_username;
        $key = $this->jingshi_key;
        $url = $this->jingshi_url.'externalhuafei';

        $data = [
            'username'=>$username,
            'key'=>$key,
            'mobile'=>$mobile,
            'pervalue'=>$pervalue,
        ];

        try {
            $content = $this->fetchContent($url, 'POST', $data);
            return json_decode($content,true);
        } catch (\Exception $e) {
            return false;
        }
    }


    public function externaljiayouka($tel,$price,$number,$name,$types) {
        $username = $this->jingshi_username;
        $key = $this->jingshi_key;
        $url = $this->jingshi_url.'externaljiayouka';

        $data = [
            'username'=>$username,
            'key'=>$key,
            'tel'=>$tel,
            'price'=>$price,
            'number'=>$number,
            'name'=>$name,
            'types'=>$types,
        ];

        try {
            $content = $this->fetchContent($url, 'POST', $data);
            return json_decode($content,true);
        } catch (\Exception $e) {
            return false;
        }
    }


    private function encode($str) {
        $res = urlencode($str);
        $res = preg_replace("/\+/", "%20", $res);
        $res = preg_replace("/\*/", "%2A", $res);
        $res = preg_replace("/%7E/", "~", $res);
        return $res;
    }

    private function fetchContent($url, $method, $body) {
        $ch = curl_init();
        if ($method == 'POST') {
            curl_setopt($ch, CURLOPT_POST, 1); //post提交方式
            curl_setopt($ch, CURLOPT_POSTFIELDS, $body);
        } else {
            $url .= '?' . $body;
        }
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_TIMEOUT, 5);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_HTTPHEADER, array(
            "x-sdk-client" => "php/2.0.0",
        ));
        if (substr($url, 0, 5) == 'https') {
            curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, false);
            curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, false);
        }
        $rtn = curl_exec($ch);
        if ($rtn === false) {
            // 大多由设置等原因引起，一般无法保障后续逻辑正常执行，
            // 所以这里触发的是E_USER_ERROR，会终止脚本执行，无法被try...catch捕获，需要用户排查环境、网络等故障
            trigger_error("[CURL_" . curl_errno($ch) . "]: " . curl_error($ch), E_USER_ERROR);
        }
        curl_close($ch);
        return $rtn;
    }
}
